/*
 * Decompiled with CFR 0.152.
 */
import brainon.std.geom.Line2d;
import brainon.std.geom.Point2d;
import brainon.std.geom.Rectangle2d;
import brainon.std.geom.Transformation;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class MorphingPlant
extends Applet {
    private Transformation mT = new Transformation();
    private Vector mBranches = new Vector();
    private Vector mParams;
    private Line2d mRoot = new Line2d(new Point2d(0.0, 0.0), new Point2d(0.0, 5.0));
    private int mBranchCount = 4;
    private int mMaxIter = 5;
    private ColorSpread mSpread = new ColorSpread(Color.white.darker(), Color.green.darker());
    private boolean mStop = false;
    private Thread mThread;
    private Image mDoubleBuffer;

    public MorphingPlant() {
        this.setBackground(Color.white);
    }

    public void init() {
        String string;
        String string2;
        Color color = null;
        Color color2 = null;
        String string3 = this.getParameter("fgStart");
        if (string3 != null) {
            color = new Color(Integer.parseInt(string3, 16));
        }
        if ((string2 = this.getParameter("fgEnd")) != null) {
            color2 = new Color(Integer.parseInt(string2, 16));
        }
        if ((string = this.getParameter("bg")) != null) {
            this.setBackground(new Color(Integer.parseInt(string, 16)));
        }
        if (color != null && color2 != null) {
            this.mSpread = new ColorSpread(color, color2);
        }
        this.addMouseListener(new 1());
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void start() {
        this.stop();
        this.mThread = new 2();
        this.mThread.setPriority(1);
        this.mThread.start();
    }

    public void stop() {
        if (this.mThread != null) {
            this.mStop = true;
            try {
                this.mThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.mStop = false;
            this.mThread = null;
        }
    }

    private void animate() {
        Dimension dimension = this.getSize();
        Rectangle2d rectangle2d = new Rectangle2d(0.25, -120.0, 0.75, 120.0);
        Rectangle2d rectangle2d2 = new Rectangle2d(0.0, 0.0, 1.0, 1.0);
        Transformation transformation = new Transformation();
        transformation.init(rectangle2d2, rectangle2d);
        int n = 80;
        Waiter waiter = new Waiter();
        block3: while (true) {
            Object object;
            Enumeration enumeration;
            Object object2;
            int n2;
            if (this.mParams == null) {
                this.mParams = new Vector();
                n2 = 0;
                while (n2 < this.mBranchCount) {
                    object2 = transformation.mul(new Point2d(Math.random(), Math.random()));
                    enumeration = transformation.mul(new Point2d(Math.random(), Math.random()));
                    this.mParams.addElement(new ParamField((Point2d)object2, (Point2d)((Object)enumeration), 80));
                    ++n2;
                }
            } else {
                Vector<ParamField> vector = new Vector<ParamField>();
                int n3 = 0;
                while (n3 < this.mBranchCount) {
                    enumeration = (ParamField)this.mParams.elementAt(n3);
                    object = transformation.mul(new Point2d(Math.random(), Math.random()));
                    vector.addElement(new ParamField(((ParamField)((Object)enumeration)).getEnd(), (Point2d)object, 80));
                    ++n3;
                }
                this.mParams = vector;
            }
            n2 = 0;
            while (true) {
                if (n2 >= 80) continue block3;
                object2 = this.mBranches;
                synchronized (object2) {
                    this.mBranches.removeAllElements();
                    enumeration = this.mParams.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (ParamField)enumeration.nextElement();
                        Point2d point2d = ((ParamField)object).getStep(n2);
                        this.mBranches.addElement(new Branch(point2d.x, point2d.y));
                    }
                }
                if (this.mStop) {
                    return;
                }
                this.paintContent();
                waiter.sleepMax(40);
                ++n2;
            }
            break;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.mDoubleBuffer, 0, 0, null);
    }

    public void paintContent() {
        Dimension dimension = this.getSize();
        if (this.mDoubleBuffer == null) {
            this.mDoubleBuffer = this.createImage(dimension.width, dimension.height);
        }
        Graphics graphics = this.mDoubleBuffer.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Vector vector = this.mBranches;
        synchronized (vector) {
            try {
                SegmentCollection segmentCollection = new SegmentCollection();
                this.calcFractal(segmentCollection, this.mRoot, 0, this.mMaxIter);
                this.setWindow(segmentCollection.getBounds());
                Enumeration enumeration = segmentCollection.elements();
                while (enumeration.hasMoreElements()) {
                    Segment segment = (Segment)enumeration.nextElement();
                    graphics.setColor(segment.color);
                    this.draw(graphics, segment.location);
                }
            }
            catch (Exception exception) {}
        }
        graphics.dispose();
        this.repaint();
    }

    public void setWindow(Rectangle2d rectangle2d) {
        Dimension dimension = this.getSize();
        Rectangle2d rectangle2d2 = new Rectangle2d(0.0, dimension.width, dimension.height, 0.0);
        double d = rectangle2d.getHeight();
        double d2 = rectangle2d.getWidth();
        double d3 = rectangle2d2.getWidth() / rectangle2d2.getHeight();
        if (d * d3 < d2) {
            d = d2 / d3;
        } else {
            d2 = d * d3;
        }
        Point2d point2d = rectangle2d.getCenter();
        rectangle2d.x1 = point2d.x - d2 / 2.0;
        rectangle2d.x2 = rectangle2d.x1 + d2;
        rectangle2d.y1 = point2d.y - d / 2.0;
        rectangle2d.y2 = rectangle2d.y1 + d;
        this.mT.init(rectangle2d, rectangle2d2);
        this.mT.init(rectangle2d, rectangle2d2);
    }

    public void calcFractal(SegmentCollection segmentCollection, Line2d line2d, int n, int n2) {
        double d = (double)n / (double)n2;
        Segment segment = new Segment();
        segment.color = this.mSpread.get(d);
        segment.location = line2d;
        segmentCollection.addElement(segment);
        if (n + 1 <= n2) {
            Enumeration enumeration = this.mBranches.elements();
            while (enumeration.hasMoreElements()) {
                Branch branch = (Branch)enumeration.nextElement();
                this.calcFractal(segmentCollection, branch.growOn(line2d), n + 1, n2);
            }
        }
    }

    public void draw(Graphics graphics, Line2d line2d) {
        Point point = this.mT.transform(line2d.start);
        Point point2 = this.mT.transform(line2d.end);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            try {
                URL uRL = null;
                uRL = !MorphingPlant.this.getCodeBase().getHost().equalsIgnoreCase("www.logicsperm.de") ? new URL("http://www.logicsperm.de") : new URL("http://www.logicsperm.de/downloads/MorphingPlant.zip");
                MorphingPlant.this.getAppletContext().showDocument(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends Thread {
        public void run() {
            MorphingPlant.this.animate();
        }

        /* synthetic */ 2() {
        }
    }
}

