/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;

public class Planet {
    private double mSpeed;
    private double mDistance;
    private double mAngle;
    private Image mImage;
    private Vector mTrabants = new Vector();

    public Planet(double d, int n, double d2, Image image) {
        this.mSpeed = d;
        this.mDistance = n;
        this.mAngle = d2;
        this.mImage = image;
    }

    public void draw(Graphics graphics, Component component, int n, int n2) {
        int n3;
        Enumeration enumeration = this.mTrabants.elements();
        while (enumeration.hasMoreElements()) {
            Planet planet = (Planet)enumeration.nextElement();
            graphics.setColor(new Color(240, 240, 240));
            graphics.drawOval((int)((double)n - planet.mDistance), (int)((double)n2 - planet.mDistance), (int)(planet.mDistance * 2.0), (int)(planet.mDistance * 2.0));
            n3 = (int)((double)n + planet.mDistance * Math.sin(planet.mAngle));
            int n4 = (int)((double)n2 + planet.mDistance * Math.cos(planet.mAngle));
            graphics.drawLine(n, n2, n3, n4);
            planet.draw(graphics, component, n3, n4);
        }
        int n5 = this.mImage.getWidth(component);
        n3 = this.mImage.getHeight(component);
        if (n5 != -1 && n3 != -1) {
            graphics.drawImage(this.mImage, n - n5 / 2, n2 - n3 / 2, component);
        }
    }

    public void step(double d) {
        this.mAngle += this.mSpeed * 2.0 * Math.PI * d;
        this.mAngle %= Math.PI * 2;
        Enumeration enumeration = this.mTrabants.elements();
        while (enumeration.hasMoreElements()) {
            ((Planet)enumeration.nextElement()).step(d);
        }
    }

    public void addTrabant(Planet planet) {
        this.mTrabants.addElement(planet);
    }
}

