/*
 * Decompiled with CFR 0.152.
 */
import brainon.std.geom.Point2d;
import brainon.std.geom.Rectangle2d;
import java.util.Vector;

class SegmentCollection
extends Vector {
    private Rectangle2d bounds = null;

    public SegmentCollection() {
        super(4096);
    }

    public void addElement(Segment segment) {
        this.updateBounds(segment.location.start);
        this.updateBounds(segment.location.end);
        super.addElement(segment);
    }

    public void updateBounds(Point2d point2d) {
        if (this.bounds == null) {
            this.bounds = new Rectangle2d();
            this.bounds.x2 = this.bounds.x1 = point2d.x;
            this.bounds.y2 = this.bounds.y1 = point2d.y;
        } else {
            if (point2d.x < this.bounds.x1) {
                this.bounds.x1 = point2d.x;
            } else if (point2d.x > this.bounds.x2) {
                this.bounds.x2 = point2d.x;
            }
            if (point2d.y < this.bounds.y1) {
                this.bounds.y1 = point2d.y;
            } else if (point2d.y > this.bounds.y2) {
                this.bounds.y2 = point2d.y;
            }
        }
    }

    public Rectangle2d getBounds() {
        return new Rectangle2d(this.bounds);
    }
}

