/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;

public class SolarSystem
extends Applet {
    private Planet mSun;
    private Image mDoubleBuffer;
    private boolean mStop;
    private Thread mThread;

    public SolarSystem() {
        this.setBackground(Color.white);
    }

    public void init() {
        try {
            this.mSun = new Planet(0.0, 0, 0.0, this.getImage(new URL(this.getCodeBase(), "sun.gif")));
            Planet planet = new Planet(0.15, 100, 0.0, this.getImage(new URL(this.getCodeBase(), "earth.gif")));
            Planet planet2 = new Planet(-0.5, 25, 0.0, this.getImage(new URL(this.getCodeBase(), "moon.gif")));
            Planet planet3 = new Planet(-0.1, 150, 0.0, this.getImage(new URL(this.getCodeBase(), "saturn.gif")));
            this.mSun.addTrabant(planet);
            this.mSun.addTrabant(planet3);
            planet.addTrabant(planet2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.startAnimation();
    }

    public void destroy() {
        this.stopAnimation();
        this.mSun = null;
    }

    public void update(Graphics graphics) {
        Object object;
        if (this.mDoubleBuffer == null) {
            object = this.getSize();
            this.mDoubleBuffer = this.createImage(((Dimension)object).width, ((Dimension)object).height);
        }
        object = this.mDoubleBuffer.getGraphics();
        super.update((Graphics)object);
        ((Graphics)object).dispose();
        graphics.drawImage(this.mDoubleBuffer, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.mSun.draw(graphics, this, dimension.width / 2, dimension.height / 2);
    }

    public void startAnimation() {
        this.mStop = false;
        this.mThread = new 1();
        this.mThread.start();
    }

    public void stopAnimation() {
        this.mStop = true;
        try {
            this.mThread.join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ void access$1(SolarSystem solarSystem, boolean bl) {
        solarSystem.mStop = bl;
    }

    static /* synthetic */ void access$3(SolarSystem solarSystem, Planet planet) {
        solarSystem.mSun = planet;
    }

    private final class 1
    extends Thread {
        public void run() {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(20L);
                    if (!SolarSystem.this.mStop) {
                        SolarSystem.this.mSun.step(0.02);
                        SolarSystem.this.repaint();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        /* synthetic */ 1() {
        }
    }
}

