/*
 * Decompiled with CFR 0.152.
 */
package brainon.std.geom;

import brainon.std.geom.Point2d;

public class Rectangle2d {
    public double x1;
    public double y1;
    public double x2;
    public double y2;

    public Rectangle2d() {
    }

    public Rectangle2d(Rectangle2d rectangle2d) {
        this.x1 = rectangle2d.x1;
        this.x2 = rectangle2d.x2;
        this.y1 = rectangle2d.y1;
        this.y2 = rectangle2d.y2;
    }

    public Rectangle2d(double d, double d2, double d3, double d4) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    public Rectangle2d(Point2d point2d, Point2d point2d2) {
        this.x1 = point2d.x;
        this.y1 = point2d.y;
        this.x2 = point2d2.x;
        this.y2 = point2d2.y;
    }

    public double getWidth() {
        return Math.abs(this.x2 - this.x1);
    }

    public double getHeight() {
        return Math.abs(this.y2 - this.y1);
    }

    public Point2d getCenter() {
        return new Point2d(this.x1 + (this.x2 - this.x1) / 2.0, this.y1 + (this.y2 - this.y1) / 2.0);
    }

    public void add(Rectangle2d rectangle2d) {
        if (rectangle2d.x1 < this.x1) {
            this.x1 = rectangle2d.x1;
        }
        if (rectangle2d.y1 < this.y1) {
            this.y1 = rectangle2d.y1;
        }
        if (rectangle2d.x2 > this.x2) {
            this.x2 = rectangle2d.x2;
        }
        if (rectangle2d.y2 > this.y2) {
            this.y2 = rectangle2d.y2;
        }
    }

    public void translate(Point2d point2d) {
        this.x1 += point2d.x;
        this.x2 += point2d.x;
        this.y1 += point2d.y;
        this.y2 += point2d.y;
    }

    public boolean intersects(Rectangle2d rectangle2d) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        if (rectangle2d.contains(this.x1, this.y1)) {
            return true;
        }
        if (rectangle2d.contains(this.x2, this.y1)) {
            return true;
        }
        if (rectangle2d.contains(this.x2, this.y2)) {
            return true;
        }
        if (rectangle2d.contains(this.x1, this.y2)) {
            return true;
        }
        if (this.contains(rectangle2d.x1, rectangle2d.y1)) {
            return true;
        }
        if (this.contains(rectangle2d.x2, rectangle2d.y1)) {
            return true;
        }
        if (this.contains(rectangle2d.x2, rectangle2d.y2)) {
            return true;
        }
        if (this.contains(rectangle2d.x1, rectangle2d.y2)) {
            return true;
        }
        if (this.x1 < this.x2) {
            d8 = this.x1;
            d7 = this.x2;
        } else {
            d8 = this.x2;
            d7 = this.x1;
        }
        if (this.y1 < this.y2) {
            d6 = this.y1;
            d5 = this.y2;
        } else {
            d6 = this.y2;
            d5 = this.y1;
        }
        if (rectangle2d.x1 < rectangle2d.x2) {
            d4 = rectangle2d.x1;
            d3 = rectangle2d.x2;
        } else {
            d4 = rectangle2d.x2;
            d3 = rectangle2d.x1;
        }
        if (rectangle2d.y1 < rectangle2d.y2) {
            d2 = rectangle2d.y1;
            d = rectangle2d.y2;
        } else {
            d2 = rectangle2d.y2;
            d = rectangle2d.y1;
        }
        if (d6 >= d2 && d6 <= d && d4 >= d8 && d4 <= d3) {
            return true;
        }
        if (d6 >= d2 && d6 <= d && d3 >= d8 && d3 <= d3) {
            return true;
        }
        if (d5 >= d2 && d5 <= d && d4 >= d8 && d4 <= d3) {
            return true;
        }
        if (d5 >= d2 && d5 <= d && d3 >= d8 && d3 <= d3) {
            return true;
        }
        if (d2 >= d6 && d2 <= d5 && d8 >= d4 && d8 <= d7) {
            return true;
        }
        if (d2 >= d6 && d2 <= d5 && d7 >= d4 && d7 <= d7) {
            return true;
        }
        if (d >= d6 && d <= d5 && d8 >= d4 && d8 <= d7) {
            return true;
        }
        return d >= d6 && d <= d5 && d7 >= d4 && d7 <= d7;
    }

    public boolean contains(Point2d point2d) {
        if (point2d.x < this.x1 && point2d.x < this.x2) {
            return false;
        }
        if (point2d.x > this.x1 && point2d.x > this.x2) {
            return false;
        }
        if (point2d.y < this.y1 && point2d.y < this.y2) {
            return false;
        }
        return !(point2d.y > this.y1) || !(point2d.y > this.y2);
    }

    public boolean contains(double d, double d2) {
        if (d < this.x1 && d < this.x2) {
            return false;
        }
        if (d > this.x1 && d > this.x2) {
            return false;
        }
        if (d2 < this.y1 && d2 < this.y2) {
            return false;
        }
        return !(d2 > this.y1) || !(d2 > this.y2);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[ x1 = " + this.x1 + " y1 = " + this.y1 + " x2 = " + this.x2 + " y2 = " + this.y2 + " ]";
    }
}

